/*
 *  kexbases\ntdll\_ntdll_apilist.c
 *
 *  Copyright (C) 2008, Xeno86
 *  Copyright (C) 2019, jumper
 *
 *  This file is part of KernelEx source code.
 *
 *  KernelEx is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published
 *  by the Free Software Foundation; version 2 of the License.
 *
 *  KernelEx is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "common.h"
#include "_ntdll_apilist.h"
#include "../kernel32/_kernel32_apilist.h"
#include "../advapi32/_advapi32_apilist.h"

BOOL init_ntdll()
{
	return TRUE;
}


/*

LdrGetProcedureAddress=LdrGetProcedureAddress  ;ie7
NtDeleteKey=NtDeleteKey  ;R041
NtQueryVolumeInformationFile=NtQueryVolumeInformationFile
RtlInterlockedCompareExchange64=RtlInterlockedCompareExchange64
 * MAKE~EXPORT InterlockedFlushSList_stub=RtlInterlockedFlushSList
RtlIsCriticalSectionLockedByThread=RtlIsCriticalSectionLockedByThread
RtlRunEncodeUnicodeString=RtlRunEncodeUnicodeString
RtlRunDecodeUnicodeString=RtlRunDecodeUnicodeString


  Fls is Vista?
 * MAKE~EXPORT FlsAlloc_stub=FlsAlloc
 * MAKE~EXPORT FlsFree_stub=FlsFree
 * MAKE~EXPORT FlsGetValue_stub=FlsGetValue
 * MAKE~EXPORT FlsSetValue_stub=FlsSetValue
*/

/* Kernel32.dll - *not in export lib?*
  MAKEEXPORT FillMemory=RtlFillMemory
  MAKEEXPORT MoveMemory=RtlMoveMemory
  MAKEEXPORT ZeroMemory=RtlZeroMemory
*/

/* kernel32\CriticalSection_fix.c redirects
  MAKE~EXPORT DeleteCriticalSection_fix=RtlDeleteCriticalSection
  MAKE~EXPORT EnterCriticalSection_fix=RtlEnterCriticalSection
  MAKE~EXPORT InitializeCriticalSectionAndSpinCount_new=RtlInitializeCriticalSectionAndSpinCount
  MAKE~EXPORT LeaveCriticalSection_fix=RtlLeaveCriticalSection
  MAKE_EXPORT SetCriticalSectionSpinCount_new=RtlSetCriticalSectionSpinCount

  DWORD WINAPI SetCriticalSectionSpinCount_new(LPCRITICAL_SECTION lpCriticalSection, DWORD dwSpinCount);
  void WINAPI EnterCriticalSection_fix(LPCRITICAL_SECTION lpCriticalSection);
  void WINAPI LeaveCriticalSection_fix(LPCRITICAL_SECTION lpCriticalSection);
  void WINAPI DeleteCriticalSection_fix(LPCRITICAL_SECTION lpCriticalSection);
*/

/* kernel32\unikernel32.c redirects
  MAKE_EXPORT GetCurrentDirectoryW_new=RtlGetCurrentDirectory_U
*/

/* kernel32\_kernel32_stubs.c redirects
  MAKE_EXPORT RtlCaptureStackBackTrace_stub=RtlCaptureStackBackTrace *Kernel32 mirror*
*/

/* ntdll\_ntdll_stubs.c redirects
  MAKE_EXPORT NtConnectPort_stub=ZwConnectPort
*/

/* kernel32\SList.c redirects
  MAKE_EXPORT RtlFirstEntrySList_new=RtlFirstEntrySList
  MAKE_EXPORT InitializeSListHead_new=RtlInitializeSListHead
  MAKE_EXPORT InterlockedFlushSList_new=RtlInterlockedFlushSList
  MAKE_EXPORT InterlockedPopEntrySList_new=RtlInterlockedPopEntrySList
  MAKE_EXPORT InterlockedPushEntrySList_new=RtlInterlockedPushEntrySList
  MAKE_EXPORT InterlockedPushListSList_new=RtlInterlockedPushListSList
  MAKE_EXPORT InterlockedPushListSListEx_new=RtlInterlockedPushListSListEx
  MAKE_EXPORT QueryDepthSList_new=RtlQueryDepthSList
*/

/* kernel32\version.c redirects **
  MAKE_EXPORT GetVersionExW_ORIG=RtlGetVersion
  MAKE_EXPORT GetVersionExW_WIN95=RtlGetVersion
  MAKE_EXPORT GetVersionExW_WIN98SE=RtlGetVersion
  MAKE_EXPORT GetVersionExW_WINME=RtlGetVersion
  MAKE_EXPORT GetVersionExW_NT40G=RtlGetVersion
  MAKE_EXPORT GetVersionExW_WIN2000D=RtlGetVersion
  MAKE_EXPORT GetVersionExW_WINXP2=RtlGetVersion
  MAKE_EXPORT GetVersionExW_WIN2003A=RtlGetVersion
  MAKE_EXPORT GetVersionExW_VISTA=RtlGetVersion
  MAKE_EXPORT GetVersionExW_WIN2008A=RtlGetVersion
  MAKE_EXPORT GetVersionExW_VISTA2=RtlGetVersion
  MAKE_EXPORT GetVersionExW_WIN7A=RtlGetVersion
  MAKE_EXPORT GetVersionExW_WIN8=RtlGetVersion
  MAKE_EXPORT GetVersionExW_WIN81=RtlGetVersion
  MAKE_EXPORT GetVersionExW_WIN10=RtlGetVersion
  MAKE_EXPORT GetVersionExW_WIN10A=RtlGetVersion
  MAKE_EXPORT GetVersionExW_WIN98=RtlGetVersion
  MAKE_EXPORT GetVersionExW_WINXP=RtlGetVersion
  MAKE_EXPORT GetVersionExW_WINXP3=RtlGetVersion
  MAKE_EXPORT VerifyVersionInfoW_WIN2000D=RtlVerifyVersionInfo
  MAKE_EXPORT VerifyVersionInfoW_WINXP2=RtlVerifyVersionInfo
  MAKE_EXPORT VerifyVersionInfoW_WIN2003A=RtlVerifyVersionInfo
  MAKE_EXPORT VerifyVersionInfoW_VISTA=RtlVerifyVersionInfo
  MAKE_EXPORT VerifyVersionInfoW_WIN2008A=RtlVerifyVersionInfo
  MAKE_EXPORT VerifyVersionInfoW_VISTA2=RtlVerifyVersionInfo
  MAKE_EXPORT VerifyVersionInfoW_WIN7A=RtlVerifyVersionInfo
  MAKE_EXPORT VerifyVersionInfoW_WIN8=RtlVerifyVersionInfo
  MAKE_EXPORT VerifyVersionInfoW_WIN81=RtlVerifyVersionInfo
  MAKE_EXPORT VerifyVersionInfoW_WIN10=RtlVerifyVersionInfo
  MAKE_EXPORT VerifyVersionInfoW_WIN10A=RtlVerifyVersionInfo
  MAKE_EXPORT VerifyVersionInfoW_WINXP=RtlVerifyVersionInfo
  MAKE_EXPORT VerifyVersionInfoW_WINXP3=RtlVerifyVersionInfo
  MAKE_EXPORT VerSetConditionMask_new=VerSetConditionMask
*/


static const apilib_named_api ntdll_named_apis[] = 
{
/*** AUTOGENERATED APILIST NAMED EXPORTS BEGIN ***/
	DECL_API("CsrGetProcessId", CsrGetProcessId_stub),
	DECL_API("DbgBreakPoint", DbgBreakPoint_stub),
	DECL_API("DbgBreakPoint", DbgBreakPoint_dbg),
	DECL_API("DbgPrint", DbgPrint_stub),
	DECL_API("DbgPrint", DbgPrint_dbg),
	DECL_API("DbgPrintEx", DbgPrintEx_stub),
	DECL_API("DbgPrintEx", DbgPrintEx_dbg),
	DECL_API("DbgPrompt", DbgPrompt_stub),
	DECL_API("DbgPrompt", DbgPrompt_dbg),
	DECL_API("KiUserApcDispatcher", KiUserApcDispatcher_stub),
	DECL_API("LdrAccessResource", LdrAccessResource_stub),
	DECL_API("LdrFindResource_U", LdrFindResource_U_stub),
	DECL_API("LdrGetDllHandle", LdrGetDllHandle_stub),
	DECL_API("LdrGetProcedureAddress", LdrGetProcedureAddress_stub),
	DECL_API("LdrLoadDll", LdrLoadDll_stub),
	DECL_API("LdrQueryProcessModuleInformation", LdrQueryProcessModuleInformation_stub),
	DECL_API("LdrShutdownProcess", LdrShutdownProcess_stub),
	DECL_API("LdrShutdownThread", LdrShutdownThread_stub),
	DECL_API("LdrUnloadDll", LdrUnloadDll_stub),
	DECL_API("NtAcceptConnectPort", NtAcceptConnectPort_stub),
	DECL_API("NtAccessCheck", NtAccessCheck_fwd),
	DECL_API("NtAccessCheckAndAuditAlarm", NtAccessCheckAndAuditAlarm_stub),
	DECL_API("NtAddAtom", NtAddAtom_stub),
	DECL_API("NtAdjustGroupsToken", NtAdjustGroupsToken_stub),
	DECL_API("NtAdjustPrivilegesToken", NtAdjustPrivilegesToken_fwd),
	DECL_API("NtAlertResumeThread", NtAlertResumeThread_stub),
	DECL_API("NtAlertThread", NtAlertThread_stub),
	DECL_API("NtAllocateLocallyUniqueId", NtAllocateLocallyUniqueId_stub),
	DECL_API("NtAllocateUuids", NtAllocateUuids_stub),
	DECL_API("NtAllocateVirtualMemory", NtAllocateVirtualMemory_new),
	DECL_API("NtCancelIoFile", NtCancelIoFile_stub),
	DECL_API("NtCancelTimer", NtCancelTimer_stub),
	DECL_API("NtClearEvent", NtClearEvent_stub),
	DECL_API("NtClose", NtClose_new),
	DECL_API("NtCloseObjectAuditAlarm", NtCloseObjectAuditAlarm_stub),
	DECL_API("NtCompactKeys", NtCompactKeys_stub),
	DECL_API("NtCompleteConnectPort", NtCompleteConnectPort_stub),
	DECL_API("NtCompressKey", NtCompressKey_stub),
	DECL_API("NtConnectPort", NtConnectPort_stub),
	DECL_API("NtContinue", NtContinue_stub),
	DECL_API("NtCreateDirectoryObject", NtCreateDirectoryObject_stub),
	DECL_API("NtCreateEvent", NtCreateEvent_stub),
	DECL_API("NtCreateEventPair", NtCreateEventPair_stub),
	DECL_API("NtCreateIoCompletion", NtCreateIoCompletion_stub),
	DECL_API("NtCreateKey", NtCreateKey_stub),
	DECL_API("NtCreateMailslotFile", NtCreateMailslotFile_stub),
	DECL_API("NtCreateMutant", NtCreateMutant_stub),
	DECL_API("NtCreateNamedPipeFile", NtCreateNamedPipeFile_stub),
	DECL_API("NtCreatePagingFile", NtCreatePagingFile_stub),
	DECL_API("NtCreatePort", NtCreatePort_stub),
	DECL_API("NtCreateProcess", NtCreateProcess_stub),
	DECL_API("NtCreateProfile", NtCreateProfile_stub),
	DECL_API("NtCreateProfileEx", NtCreateProfileEx_stub),
	DECL_API("NtCreateSection", NtCreateSection_stub),
	DECL_API("NtCreateSemaphore", NtCreateSemaphore_stub),
	DECL_API("NtCreateSymbolicLinkObject", NtCreateSymbolicLinkObject_stub),
	DECL_API("NtCreateThread", NtCreateThread_stub),
	DECL_API("NtCreateTimer", NtCreateTimer_stub),
	DECL_API("NtCreateToken", NtCreateToken_stub),
	DECL_API("NtDelayExecution", NtDelayExecution_stub),
	DECL_API("NtDeleteAtom", NtDeleteAtom_stub),
	DECL_API("NtDeleteFile", NtDeleteFile_stub),
	DECL_API("NtDeleteKey", NtDeleteKey_stub),
	DECL_API("NtDeleteObjectAuditAlarm", NtDeleteObjectAuditAlarm_stub),
	DECL_API("NtDeleteValueKey", NtDeleteValueKey_stub),
	DECL_API("NtDeviceIoControlFile", NtDeviceIoControlFile_stub),
	DECL_API("NtDisplayString", NtDisplayString_stub),
	DECL_API("NtDuplicateObject", NtDuplicateObject_stub),
	DECL_API("NtDuplicateToken", NtDuplicateToken_fwd),
	DECL_API("NtEnumerateKey", NtEnumerateKey_stub),
	DECL_API("NtEnumerateValueKey", NtEnumerateValueKey_stub),
	DECL_API("NtExtendSection", NtExtendSection_stub),
	DECL_API("NtFindAtom", NtFindAtom_stub),
	DECL_API("NtFlushBuffersFile", NtFlushBuffersFile_stub),
	DECL_API("NtFlushInstructionCache", NtFlushInstructionCache_stub),
	DECL_API("NtFlushKey", NtFlushKey_stub),
	DECL_API("NtFlushVirtualMemory", NtFlushVirtualMemory_stub),
	DECL_API("NtFreeVirtualMemory", NtFreeVirtualMemory_stub),
	DECL_API("NtFsControlFile", NtFsControlFile_stub),
	DECL_API("NtGetContextThread", NtGetContextThread_stub),
	DECL_API("NtGetTickCount", NtGetTickCount_stub),
	DECL_API("NtImpersonateClientOfPort", NtImpersonateClientOfPort_stub),
	DECL_API("NtImpersonateThread", NtImpersonateThread_stub),
	DECL_API("NtListenPort", NtListenPort_stub),
	DECL_API("NtLoadDriver", NtLoadDriver_stub),
	DECL_API("NtLoadKey", NtLoadKey_stub),
	DECL_API("NtLockFile", NtLockFile_stub),
	DECL_API("NtLockVirtualMemory", NtLockVirtualMemory_stub),
	DECL_API("NtMakeTemporaryObject", NtMakeTemporaryObject_stub),
	DECL_API("NtMapViewOfSection", NtMapViewOfSection_stub),
	DECL_API("NtNotifyChangeDirectoryFile", NtNotifyChangeDirectoryFile_stub),
	DECL_API("NtNotifyChangeKey", NtNotifyChangeKey_stub),
	DECL_API("NtOpenDirectoryObject", NtOpenDirectoryObject_stub),
	DECL_API("NtOpenEvent", NtOpenEvent_stub),
	DECL_API("NtOpenEventPair", NtOpenEventPair_stub),
	DECL_API("NtOpenFile", NtOpenFile_stub),
	DECL_API("NtOpenIoCompletion", NtOpenIoCompletion_stub),
	DECL_API("NtOpenKey", NtOpenKey_stub),
	DECL_API("NtOpenMutant", NtOpenMutant_stub),
	DECL_API("NtOpenObjectAuditAlarm", NtOpenObjectAuditAlarm_stub),
	DECL_API("NtOpenProcess", NtOpenProcess_stub),
	DECL_API("NtOpenProcessToken", NtOpenProcessToken_fwd),
	DECL_API("NtOpenSection", NtOpenSection_stub),
	DECL_API("NtOpenSemaphore", NtOpenSemaphore_stub),
	DECL_API("NtOpenSymbolicLinkObject", NtOpenSymbolicLinkObject_stub),
	DECL_API("NtOpenThread", NtOpenThread_stub),
	DECL_API("NtOpenThreadToken", NtOpenThreadToken_fwd),
	DECL_API("NtOpenTimer", NtOpenTimer_stub),
	DECL_API("NtPrivilegeCheck", NtPrivilegeCheck_stub),
	DECL_API("NtPrivilegeObjectAuditAlarm", NtPrivilegeObjectAuditAlarm_stub),
	DECL_API("NtPrivilegedServiceAuditAlarm", NtPrivilegedServiceAuditAlarm_stub),
	DECL_API("NtProtectVirtualMemory", NtProtectVirtualMemory_stub),
	DECL_API("NtPulseEvent", NtPulseEvent_stub),
	DECL_API("NtQueryAttributesFile", NtQueryAttributesFile_stub),
	DECL_API("NtQueryDefaultLocale", NtQueryDefaultLocale_stub),
	DECL_API("NtQueryDirectoryFile", NtQueryDirectoryFile_stub),
	DECL_API("NtQueryDirectoryObject", NtQueryDirectoryObject_stub),
	DECL_API("NtQueryEaFile", NtQueryEaFile_stub),
	DECL_API("NtQueryEvent", NtQueryEvent_stub),
	DECL_API("NtQueryFullAttributesFile", NtQueryFullAttributesFile_stub),
	DECL_API("NtQueryInformationAtom", NtQueryInformationAtom_stub),
	DECL_API("NtQueryInformationFile", NtQueryInformationFile_stub),
	DECL_API("NtQueryInformationPort", NtQueryInformationPort_stub),
	DECL_API("NtQueryInformationProcess", NtQueryInformationProcess_stub),
	DECL_API("NtQueryInformationThread", NtQueryInformationThread_stub),
	DECL_API("NtQueryInformationToken", NtQueryInformationToken_fwd),
	DECL_API("NtQueryIntervalProfile", NtQueryIntervalProfile_stub),
	DECL_API("NtQueryIoCompletion", NtQueryIoCompletion_stub),
	DECL_API("NtQueryKey", NtQueryKey_stub),
	DECL_API("NtQueryMultipleValueKey", NtQueryMultipleValueKey_stub),
	DECL_API("NtQueryMutant", NtQueryMutant_stub),
	DECL_API("NtQueryObject", NtQueryObject_stub),
	DECL_API("NtQueryOleDirectoryFile", NtQueryOleDirectoryFile_stub),
	DECL_API("NtQueryOpenSubKeys", NtQueryOpenSubKeys_stub),
	DECL_API("NtQueryPerformanceCounter", NtQueryPerformanceCounter_new),
	DECL_API("NtQuerySection", NtQuerySection_stub),
	DECL_API("NtQuerySecurityObject", NtQuerySecurityObject_stub),
	DECL_API("NtQuerySemaphore", NtQuerySemaphore_stub),
	DECL_API("NtQuerySymbolicLinkObject", NtQuerySymbolicLinkObject_stub),
	DECL_API("NtQuerySystemEnvironmentValue", NtQuerySystemEnvironmentValue_stub),
	DECL_API("NtQuerySystemInformation", NtQuerySystemInformation_stub),
	DECL_API("NtQuerySystemTime", NtQuerySystemTime_new),
	DECL_API("NtQueryTimer", NtQueryTimer_stub),
	DECL_API("NtQueryTimerResolution", NtQueryTimerResolution_stub),
	DECL_API("NtQueryValueKey", NtQueryValueKey_stub),
	DECL_API("NtQueryVirtualMemory", NtQueryVirtualMemory_stub),
	DECL_API("NtQueryVolumeInformationFile", NtQueryVolumeInformationFile_stub),
	DECL_API("NtQueueApcThread", NtQueueApcThread_stub),
	DECL_API("NtRaiseException", NtRaiseException_stub),
	DECL_API("NtRaiseHardError", NtRaiseHardError_stub),
	DECL_API("NtReadFile", NtReadFile_stub),
	DECL_API("NtReadFileScatter", NtReadFileScatter_stub),
	DECL_API("NtReadRequestData", NtReadRequestData_stub),
	DECL_API("NtReadVirtualMemory", NtReadVirtualMemory_stub),
	DECL_API("NtRegisterThreadTerminatePort", NtRegisterThreadTerminatePort_stub),
	DECL_API("NtReleaseMutant", NtReleaseMutant_stub),
	DECL_API("NtReleaseSemaphore", NtReleaseSemaphore_stub),
	DECL_API("NtRemoveIoCompletion", NtRemoveIoCompletion_stub),
	DECL_API("NtReplaceKey", NtReplaceKey_stub),
	DECL_API("NtReplyPort", NtReplyPort_stub),
	DECL_API("NtReplyWaitReceivePort", NtReplyWaitReceivePort_stub),
	DECL_API("NtReplyWaitReplyPort", NtReplyWaitReplyPort_stub),
	DECL_API("NtRequestPort", NtRequestPort_stub),
	DECL_API("NtRequestWaitReplyPort", NtRequestWaitReplyPort_stub),
	DECL_API("NtResetEvent", NtResetEvent_stub),
	DECL_API("NtRestoreKey", NtRestoreKey_stub),
	DECL_API("NtResumeThread", NtResumeThread_stub),
	DECL_API("NtSaveKey", NtSaveKey_stub),
	DECL_API("NtSetContextThread", NtSetContextThread_stub),
	DECL_API("NtSetDefaultHardErrorPort", NtSetDefaultHardErrorPort_stub),
	DECL_API("NtSetDefaultLocale", NtSetDefaultLocale_stub),
	DECL_API("NtSetEaFile", NtSetEaFile_stub),
	DECL_API("NtSetEvent", NtSetEvent_stub),
	DECL_API("NtSetHighEventPair", NtSetHighEventPair_stub),
	DECL_API("NtSetHighWaitLowEventPair", NtSetHighWaitLowEventPair_stub),
	DECL_API("NtSetHighWaitLowThread", NtSetHighWaitLowThread_stub),
	DECL_API("NtSetInformationFile", NtSetInformationFile_stub),
	DECL_API("NtSetInformationKey", NtSetInformationKey_stub),
	DECL_API("NtSetInformationObject", NtSetInformationObject_stub),
	DECL_API("NtSetInformationProcess", NtSetInformationProcess_stub),
	DECL_API("NtSetInformationThread", NtSetInformationThread_stub),
	DECL_API("NtSetInformationToken", NtSetInformationToken_stub),
	DECL_API("NtSetIntervalProfile", NtSetIntervalProfile_stub),
	DECL_API("NtSetIoCompletion", NtSetIoCompletion_stub),
	DECL_API("NtSetLowEventPair", NtSetLowEventPair_stub),
	DECL_API("NtSetLowWaitHighEventPair", NtSetLowWaitHighEventPair_stub),
	DECL_API("NtSetLowWaitHighThread", NtSetLowWaitHighThread_stub),
	DECL_API("NtSetSecurityObject", NtSetSecurityObject_stub),
	DECL_API("NtSetSystemEnvironmentValue", NtSetSystemEnvironmentValue_stub),
	DECL_API("NtSetSystemInformation", NtSetSystemInformation_stub),
	DECL_API("NtSetSystemTime", NtSetSystemTime_stub),
	DECL_API("NtSetTimer", NtSetTimer_stub),
	DECL_API("NtSetTimerResolution", NtSetTimerResolution_stub),
	DECL_API("NtSetValueKey", NtSetValueKey_stub),
	DECL_API("NtSetVolumeInformationFile", NtSetVolumeInformationFile_stub),
	DECL_API("NtShutdownSystem", NtShutdownSystem_new),
	DECL_API("NtSignalAndWaitForSingleObject", NtSignalAndWaitForSingleObject_stub),
	DECL_API("NtStartProfile", NtStartProfile_stub),
	DECL_API("NtStopProfile", NtStopProfile_stub),
	DECL_API("NtSuspendThread", NtSuspendThread_stub),
	DECL_API("NtTerminateProcess", NtTerminateProcess_stub),
	DECL_API("NtTerminateThread", NtTerminateThread_stub),
	DECL_API("NtTestAlert", NtTestAlert_stub),
	DECL_API("NtUnloadDriver", NtUnloadDriver_stub),
	DECL_API("NtUnloadKey", NtUnloadKey_stub),
	DECL_API("NtUnlockFile", NtUnlockFile_stub),
	DECL_API("NtUnlockVirtualMemory", NtUnlockVirtualMemory_stub),
	DECL_API("NtUnmapViewOfSection", NtUnmapViewOfSection_stub),
	DECL_API("NtWaitForMultipleObjects", NtWaitForMultipleObjects_stub),
	DECL_API("NtWaitForSingleObject", NtWaitForSingleObject_new),
	DECL_API("NtWaitHighEventPair", NtWaitHighEventPair_stub),
	DECL_API("NtWaitLowEventPair", NtWaitLowEventPair_stub),
	DECL_API("NtWriteFile", NtWriteFile_stub),
	DECL_API("NtWriteFileGather", NtWriteFileGather_stub),
	DECL_API("NtWriteRequestData", NtWriteRequestData_stub),
	DECL_API("NtWriteVirtualMemory", NtWriteVirtualMemory_stub),
	DECL_API("NtYieldExecution", NtYieldExecution_stub),
	DECL_API("RtlAcquireResourceExclusive", RtlAcquireResourceExclusive_stub),
	DECL_API("RtlAcquireResourceShared", RtlAcquireResourceShared_stub),
	DECL_API("RtlAddAccessAllowedAce", RtlAddAccessAllowedAce_fwd),
	DECL_API("RtlAddAccessAllowedAceEx", RtlAddAccessAllowedAceEx_stub),
	DECL_API("RtlAddAccessDeniedAce", RtlAddAccessDeniedAce_stub),
	DECL_API("RtlAddAccessDeniedAceEx", RtlAddAccessDeniedAceEx_stub),
	DECL_API("RtlAddAce", RtlAddAce_stub),
	DECL_API("RtlAddAuditAccessAce", RtlAddAuditAccessAce_stub),
	DECL_API("RtlAdjustPrivilege", RtlAdjustPrivilege),
	DECL_API("RtlAllocateAndInitializeSid", RtlAllocateAndInitializeSid_fwd),
	DECL_API("RtlAllocateHeap", RtlAllocateHeap_stub),
	DECL_API("RtlAnsiStringToUnicodeSize", RtlAnsiStringToUnicodeSize_new),
	DECL_API("RtlAnsiStringToUnicodeString", RtlAnsiStringToUnicodeString_fix),
	DECL_API("RtlAppendUnicodeStringToString", RtlAppendUnicodeStringToString_stub),
	DECL_API("RtlAppendUnicodeToString", RtlAppendUnicodeToString_stub),
	DECL_API("RtlAssert", RtlAssert_stub),
	DECL_API("RtlCaptureStackBackTrace", RtlCaptureStackBackTrace_stub),
	DECL_API("RtlCharToInteger", RtlCharToInteger_stub),
	DECL_API("RtlCompactHeap", RtlCompactHeap_stub),
	DECL_API("RtlCompareMemory", RtlCompareMemory_stub),
	DECL_API("RtlCompareUnicodeString", RtlCompareUnicodeString_new),
	DECL_API("RtlCompressBuffer", RtlCompressBuffer_stub),
	DECL_API("RtlConvertSidToUnicodeString", RtlConvertSidToUnicodeString_stub),
	DECL_API("RtlCopySid", RtlCopySid),
	DECL_API("RtlCopyUnicodeString", RtlCopyUnicodeString_new),
	DECL_API("RtlCreateEnvironment", RtlCreateEnvironment_stub),
	DECL_API("RtlCreateHeap", RtlCreateHeap_stub),
	DECL_API("RtlCreateSecurityDescriptor", RtlCreateSecurityDescriptor),
	DECL_API("RtlCreateTagHeap", RtlCreateTagHeap),
	DECL_API("RtlCreateUnicodeString", RtlCreateUnicodeString_new),
	DECL_API("RtlCreateUnicodeStringFromAsciiz", RtlCreateUnicodeStringFromAsciiz_new),
	DECL_API("RtlCreateUserProcess", RtlCreateUserProcess_stub),
	DECL_API("RtlCreateUserThread", RtlCreateUserThread),
	DECL_API("RtlDecompressBuffer", RtlDecompressBuffer_stub),
	DECL_API("RtlDeleteAce", RtlDeleteAce_fwd),
	DECL_API("RtlDeleteCriticalSection", RtlDeleteCriticalSection_new),
	DECL_API("RtlDeleteResource", RtlDeleteResource_stub),
	DECL_API("RtlDeleteSecurityObject", RtlDeleteSecurityObject_stub),
	DECL_API("RtlDestroyEnvironment", RtlDestroyEnvironment_stub),
	DECL_API("RtlDestroyHeap", RtlDestroyHeap_stub),
	DECL_API("RtlDosPathNameToNtPathName_U", RtlDosPathNameToNtPathName_U_stub),
	DECL_API("RtlDuplicateUnicodeString", RtlDuplicateUnicodeString_new),
	DECL_API("RtlEnterCriticalSection", RtlEnterCriticalSection_new),
	DECL_API("RtlEnumProcessHeaps", RtlEnumProcessHeaps_stub),
	DECL_API("RtlEqualPrefixSid", RtlEqualPrefixSid_fwd),
	DECL_API("RtlEqualSid", RtlEqualSid_fwd),
	DECL_API("RtlEqualUnicodeString", RtlEqualUnicodeString_new),
	DECL_API("RtlExpandEnvironmentStrings_U", RtlExpandEnvironmentStrings_U_new),
	DECL_API("RtlFirstEntrySList", RtlFirstEntrySList_new),
	DECL_API("RtlFirstFreeAce", RtlFirstFreeAce_stub),
	DECL_API("RtlFormatCurrentUserKeyPath", RtlFormatCurrentUserKeyPath_stub),
	DECL_API("RtlFreeAnsiString", RtlFreeString_new),
	DECL_API("RtlFreeHeap", RtlFreeHeap_stub),
	DECL_API("RtlFreeOemString", RtlFreeString_new),
	DECL_API("RtlFreeSid", RtlFreeSid),
	DECL_API("RtlFreeUnicodeString", RtlFreeString_new),
	DECL_API("RtlGUIDFromString", RtlGUIDFromString_stub),
	DECL_API("RtlGetAce", RtlGetAce_fwd),
	DECL_API("RtlGetCompressionWorkSpaceSize", RtlGetCompressionWorkSpaceSize_stub),
	DECL_API("RtlGetControlSecurityDescriptor", RtlGetControlSecurityDescriptor_fwd),
	DECL_API("RtlGetCurrentDirectory_U", GetCurrentDirectoryW_new),
	DECL_API("RtlGetDaclSecurityDescriptor", RtlGetDaclSecurityDescriptor_fwd),
	DECL_API("RtlGetGroupSecurityDescriptor", RtlGetGroupSecurityDescriptor_fwd),
	DECL_API("RtlGetHandleValueHeap", RtlGetHandleValueHeap_stub),
	DECL_API("RtlGetNtProductType", RtlGetNtProductType_stub),
	DECL_API("RtlGetOwnerSecurityDescriptor", RtlGetOwnerSecurityDescriptor_fwd),
	DECL_API("RtlGetProcessHeaps", RtlGetProcessHeaps_stub),
	DECL_API("RtlGetSaclSecurityDescriptor", RtlGetSaclSecurityDescriptor_fwd),
	DECL_API("RtlGetVersion", GetVersionExW_ORIG),
	DECL_API("RtlGetVersion", GetVersionExW_WIN95),
	DECL_API("RtlGetVersion", GetVersionExW_WIN98SE),
	DECL_API("RtlGetVersion", GetVersionExW_WINME),
	DECL_API("RtlGetVersion", GetVersionExW_NT40G),
	DECL_API("RtlGetVersion", GetVersionExW_WIN2000D),
	DECL_API("RtlGetVersion", GetVersionExW_WINXP2),
	DECL_API("RtlGetVersion", GetVersionExW_WIN2003A),
	DECL_API("RtlGetVersion", GetVersionExW_VISTA),
	DECL_API("RtlGetVersion", GetVersionExW_WIN2008A),
	DECL_API("RtlGetVersion", GetVersionExW_VISTA2),
	DECL_API("RtlGetVersion", GetVersionExW_WIN7A),
	DECL_API("RtlGetVersion", GetVersionExW_WIN8),
	DECL_API("RtlGetVersion", GetVersionExW_WIN81),
	DECL_API("RtlGetVersion", GetVersionExW_WIN10),
	DECL_API("RtlGetVersion", GetVersionExW_WIN10A),
	DECL_API("RtlGetVersion", GetVersionExW_WIN98),
	DECL_API("RtlGetVersion", GetVersionExW_WINXP),
	DECL_API("RtlGetVersion", GetVersionExW_WINXP3),
	DECL_API("RtlGrowHeap", RtlGrowHeap_stub),
	DECL_API("RtlIdentifierAuthoritySid", RtlIdentifierAuthoritySid_fwd),
	DECL_API("RtlInitAnsiString", RtlInitString_new),
	DECL_API("RtlInitAnsiStringEx", RtlInitStringEx_new),
	DECL_API("RtlInitOemString", RtlInitString_new),
	DECL_API("RtlInitOemStringEx", RtlInitStringEx_new),
	DECL_API("RtlInitString", RtlInitString_new),
	DECL_API("RtlInitUnicodeString", RtlInitUnicodeString_new),
	DECL_API("RtlInitUnicodeStringEx", RtlInitUnicodeStringEx_new),
	DECL_API("RtlInitializeBitMap", RtlInitializeBitMap),
	DECL_API("RtlInitializeCriticalSection", RtlInitializeCriticalSection_new),
	DECL_API("RtlInitializeCriticalSectionAndSpinCount", RtlInitializeCriticalSectionAndSpinCount_new),
	DECL_API("RtlInitializeCriticalSectionEx", RtlInitializeCriticalSectionEx_new),
	DECL_API("RtlInitializeResource", RtlInitializeResource_stub),
	DECL_API("RtlInitializeSListHead", InitializeSListHead_new),
	DECL_API("RtlInitializeSid", RtlInitializeSid),
	DECL_API("RtlInterlockedCompareExchange64", RtlInterlockedCompareExchange64_new),
	DECL_API("RtlInterlockedFlushSList", InterlockedFlushSList_new),
	DECL_API("RtlInterlockedPopEntrySList", InterlockedPopEntrySList_new),
	DECL_API("RtlInterlockedPushEntrySList", InterlockedPushEntrySList_new),
	DECL_API("RtlInterlockedPushListSList", InterlockedPushListSList_new),
	DECL_API("RtlInterlockedPushListSListEx", InterlockedPushListSListEx_new),
	DECL_API("RtlIpv4StringToAddressW", RtlIpv4StringToAddressW_stub),
	DECL_API("RtlIsCriticalSectionLocked", RtlIsCriticalSectionLocked_stub),
	DECL_API("RtlIsCriticalSectionLockedByThread", RtlIsCriticalSectionLockedByThread_stub),
	DECL_API("RtlLeaveCriticalSection", RtlLeaveCriticalSection_new),
	DECL_API("RtlLengthRequiredSid", RtlLengthRequiredSid),
	DECL_API("RtlLengthSid", RtlLengthSid),
	DECL_API("RtlLockHeap", RtlLockHeap_stub),
	DECL_API("RtlMultiByteToUnicodeN", RtlMultiByteToUnicodeN_new),
	DECL_API("RtlMultiByteToUnicodeSize", RtlMultiByteToUnicodeSize_new),
	DECL_API("RtlNewSecurityObject", RtlNewSecurityObject_stub),
	DECL_API("RtlOemStringToUnicodeSize", RtlOemStringToUnicodeSize_new),
	DECL_API("RtlOemStringToUnicodeString", RtlOemStringToUnicodeString_new),
	DECL_API("RtlOemToUnicodeN", RtlOemToUnicodeN_new),
	DECL_API("RtlPrefixUnicodeString", RtlPrefixUnicodeString_new),
	DECL_API("RtlProtectHeap", RtlProtectHeap_stub),
	DECL_API("RtlQueryDepthSList", QueryDepthSList_new),
	DECL_API("RtlQueryEnvironmentVariable_U", RtlQueryEnvironmentVariable_U_stub),
	DECL_API("RtlQueryInformationAcl", RtlQueryInformationAcl_stub),
	DECL_API("RtlQuerySecurityObject", RtlQuerySecurityObject_stub),
	DECL_API("RtlRaiseStatus", RtlRaiseStatus),
	DECL_API("RtlReAllocateHeap", RtlReAllocateHeap_stub),
	DECL_API("RtlReleaseResource", RtlReleaseResource_stub),
	DECL_API("RtlRunDecodeUnicodeString", RtlRunDecodeUnicodeString_new),
	DECL_API("RtlRunEncodeUnicodeString", RtlRunEncodeUnicodeString_new),
	DECL_API("RtlSecondsSince1970ToTime", RtlSecondsSince1970ToTime_new),
	DECL_API("RtlSecondsSince1980ToTime", RtlSecondsSince1980ToTime_new),
	DECL_API("RtlSetControlSecurityDescriptor", RtlSetControlSecurityDescriptor_stub),
	DECL_API("RtlSetCriticalSectionSpinCount", SetCriticalSectionSpinCount_new),
	DECL_API("RtlSetCurrentEnvironment", RtlSetCurrentEnvironment_stub),
	DECL_API("RtlSetDaclSecurityDescriptor", RtlSetDaclSecurityDescriptor_fwd),
	DECL_API("RtlSetEnvironmentVariable", RtlSetEnvironmentVariable_stub),
	DECL_API("RtlSetGroupSecurityDescriptor", RtlSetGroupSecurityDescriptor_fwd),
	DECL_API("RtlSetHandleValueHeap", RtlSetHandleValueHeap_stub),
	DECL_API("RtlSetInformationAcl", RtlSetInformationAcl_stub),
	DECL_API("RtlSetOwnerSecurityDescriptor", RtlSetOwnerSecurityDescriptor_fwd),
	DECL_API("RtlSetSaclSecurityDescriptor", RtlSetSaclSecurityDescriptor_stub),
	DECL_API("RtlSetSecurityObject", RtlSetSecurityObject_stub),
	DECL_API("RtlSizeHeap", RtlSizeHeap_stub),
	DECL_API("RtlSubAuthorityCountSid", RtlSubAuthorityCountSid_fwd),
	DECL_API("RtlSubAuthoritySid", RtlSubAuthoritySid),
	DECL_API("RtlSystemTimeToLocalTime", RtlSystemTimeToLocalTime),
	DECL_API("RtlTimeFieldsToTime", RtlTimeFieldsToTime_stub),
	DECL_API("RtlTimeToSecondsSince1970", RtlTimeToSecondsSince1970_new),
	DECL_API("RtlTimeToSecondsSince1980", RtlTimeToSecondsSince1980_new),
	DECL_API("RtlTimeToTimeFields", RtlTimeToTimeFields_stub),
	DECL_API("RtlTryEnterCriticalSection", RtlTryEnterCriticalSection_new),
	DECL_API("RtlUnicodeStringToAnsiSize", RtlUnicodeStringToASize_new),
	DECL_API("RtlUnicodeStringToAnsiString", RtlUnicodeStringToAnsiString_fix),
	DECL_API("RtlUnicodeStringToInteger", RtlUnicodeStringToInteger_stub),
	DECL_API("RtlUnicodeStringToOemSize", RtlUnicodeStringToASize_new),
	DECL_API("RtlUnicodeStringToOemString", RtlUnicodeStringToOemString_new),
	DECL_API("RtlUnicodeToMultiByteN", RtlUnicodeToMultiByteN_new),
	DECL_API("RtlUnicodeToMultiByteSize", RtlUnicodeToMultiByteSize_new),
	DECL_API("RtlUniform", RtlUniform_new),
	DECL_API("RtlUnlockHeap", RtlUnlockHeap_stub),
	DECL_API("RtlUpcaseUnicodeChar", RtlUpcaseUnicodeChar_new),
	DECL_API("RtlUpcaseUnicodeString", RtlUpcaseUnicodeString_new),
	DECL_API("RtlUpcaseUnicodeToMultiByteN", RtlUpcaseUnicodeToMultiByteN_stub),
	DECL_API("RtlValidAcl", RtlValidAcl_stub),
	DECL_API("RtlValidSecurityDescriptor", RtlValidSecurityDescriptor_fwd),
	DECL_API("RtlValidSid", RtlValidSid_fwd),
	DECL_API("RtlValidateHeap", RtlValidateHeap_stub),
	DECL_API("RtlValidateProcessHeaps", RtlValidateProcessHeaps_stub),
	DECL_API("RtlVerifyVersionInfo", VerifyVersionInfoW_WIN2000D),
	DECL_API("RtlVerifyVersionInfo", VerifyVersionInfoW_WINXP2),
	DECL_API("RtlVerifyVersionInfo", VerifyVersionInfoW_WIN2003A),
	DECL_API("RtlVerifyVersionInfo", VerifyVersionInfoW_VISTA),
	DECL_API("RtlVerifyVersionInfo", VerifyVersionInfoW_WIN2008A),
	DECL_API("RtlVerifyVersionInfo", VerifyVersionInfoW_VISTA2),
	DECL_API("RtlVerifyVersionInfo", VerifyVersionInfoW_WIN7A),
	DECL_API("RtlVerifyVersionInfo", VerifyVersionInfoW_WIN8),
	DECL_API("RtlVerifyVersionInfo", VerifyVersionInfoW_WIN81),
	DECL_API("RtlVerifyVersionInfo", VerifyVersionInfoW_WIN10),
	DECL_API("RtlVerifyVersionInfo", VerifyVersionInfoW_WIN10A),
	DECL_API("RtlVerifyVersionInfo", VerifyVersionInfoW_WINXP),
	DECL_API("RtlVerifyVersionInfo", VerifyVersionInfoW_WINXP3),
	DECL_API("RtlWalkHeap", RtlWalkHeap_stub),
	DECL_API("RtlpAllocateMemory", RtlpAllocateMemory_new),
	DECL_API("RtlpEnsureBufferSize", RtlpEnsureBufferSize_stub),
	DECL_API("RtlxAnsiStringToUnicodeSize", RtlAnsiStringToUnicodeSize_new),
	DECL_API("RtlxOemStringToUnicodeSize", RtlOemStringToUnicodeSize_new),
	DECL_API("RtlxUnicodeStringToAnsiSize", RtlUnicodeStringToASize_new),
	DECL_API("RtlxUnicodeStringToOemSize", RtlUnicodeStringToASize_new),
	DECL_API("VerSetConditionMask", VerSetConditionMask_new),
	DECL_API("ZwClose", NtClose_new),
	DECL_API("ZwConnectPort", NtConnectPort_stub),
	DECL_API("vDbgPrintEx", vDbgPrintEx_stub),
	DECL_API("vDbgPrintEx", vDbgPrintEx_dbg),
	DECL_API("vDbgPrintExWithPrefix", vDbgPrintExWithPrefix_stub),
	DECL_API("vDbgPrintExWithPrefix", vDbgPrintExWithPrefix_dbg),
/*** AUTOGENERATED APILIST NAMED EXPORTS END ***/
};

#ifndef ntdll_ordinal_apis
static const apilib_unnamed_api ntdll_ordinal_apis[] =
{
/*** AUTOGENERATED APILIST ORDINAL EXPORTS BEGIN ***/
/*** AUTOGENERATED APILIST ORDINAL EXPORTS END ***/
};
#endif

const apilib_api_table apitable_ntdll =
  DECL_TAB("NTDLL.DLL", ntdll_named_apis, ntdll_ordinal_apis);
